﻿package
{
	import flash.display.MovieClip;
	
	import com.greensock.TweenLite;
	import com.greensock.easing.*;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	
	public class PlayerContainer extends MovieClip
	{
		public static const DECORATION_FREQUENCY : int = 6;
		public static const DECORATION_DEVIATION : int = 2;
		
		public var player_mc : Player;
		public var background_layer_mc : MovieClip;
		public var dot_layer_mc : DotLayer;
		public var obstacle_layer_mc : ObstacleLayer;
		public var decoration_layer_mc : DecorationLayer;
		public var wave_layer_mc : WaveLayer;
		public var sun_moon_layer_mc : SunMoonLayer;
		public var text_layer_mc : TextLayer;
		
		public var _decoration_timer : Timer;

		public function PlayerContainer()
		{
			_decoration_timer = new Timer(DECORATION_FREQUENCY * 1000, 0);
			_decoration_timer.addEventListener(TimerEvent.TIMER, handleTimer);
			_decoration_timer.start();
		}
		
		public function handleTimer (e : TimerEvent) : void
		{
			_decoration_timer.delay = (DECORATION_FREQUENCY + (DECORATION_DEVIATION - (2 * Math.random() * DECORATION_DEVIATION))) * 1000;
			addRandomDecoration();
		}
		
		public function addRandomDecoration() : void
		{
			if (player_mc)
			{
				var randomValue : Number = Math.random();
				var decoElement : MovieClip;
			

				if (player_mc.title == Main.PLAYER1_TITLE)
				{
					if (randomValue < 0.15)
					{
						decoElement = new LandDecoration1();
					}
					else if (randomValue < 0.3)
					{
						decoElement = new LandDecoration2();
					}
					else if (randomValue < 0.45)
					{
						decoElement = new LandDecoration3();
					}
					else if (randomValue < 0.6)
					{
						decoElement = new LandDecoration4();
					}
					else if (randomValue < 0.75)
					{
						decoElement = new LandDecoration5();
					}
					else if (randomValue < 0.9)
					{
						decoElement = new LandDecoration7();
					}
					else
					{
						decoElement = new LandDecoration8();
					}
				}
				else if (player_mc.title == Main.PLAYER2_TITLE)
				{
					if (randomValue < 0.15)
					{
						decoElement = new WaterDecoration1();
					}
					else if (randomValue < 0.3)
					{
						decoElement = new WaterDecoration2();
					}
					else if (randomValue < 0.45)
					{
						decoElement = new WaterDecoration3();
					}
					else if (randomValue < 0.65)
					{
						decoElement = new WaterDecoration4();
					}
					else if (randomValue < 0.85)
					{
						decoElement = new WaterDecoration5();
					}
					else
					{
						decoElement = new WaterDecoration6();
					}
				}
				
				if (decoElement)
				{
					decoElement.x = Main.CONTAINER_WIDTH;
					decoElement.y = Main.CONTAINER_HEIGHT;
					decoElement.scaleX = 0.5;
					decoElement.scaleY = 0.5;
				
					decoration_layer_mc.addObject(decoElement);
				}
			}
		}
		
		public function reset() : void
		{
			player_mc.reset();
			dot_layer_mc.reset();
			obstacle_layer_mc.reset();
			decoration_layer_mc.reset();
			text_layer_mc.reset();
		}
		
		public function moveUpWave () : void
		{
				TweenLite.to(this.wave_layer_mc.wave_mc, Main.MOVE_MAX_DURATION / 2, {y: Main.MOVE_MAX_HEIGHT + Main.WAVE_MOVE_UP_OFFSET, 
					ease:Sine.easeOut, onComplete:handleMoveUpWaveFinished});
		}
		
		public function handleMoveUpWaveFinished () : void
		{
				TweenLite.to(this.wave_layer_mc.wave_mc, Main.MOVE_MAX_DURATION / 2, {y: Main.CONTAINER_HEIGHT, 
					ease:Sine.easeIn});
		}
		
		public function update() : void
		{
			dot_layer_mc.updateObjects(Main.SPEED);
			obstacle_layer_mc.updateObjects(Main.SPEED);
			decoration_layer_mc.updateObjects(Main.SPEED/4);
			
			var currentDate = new Date();
			this.sun_moon_layer_mc.sun_moon_mc.x = Utils.map((currentDate.hours * 60) + currentDate.minutes,
															0,1440,0,Main.CONTAINER_WIDTH);
			this.sun_moon_layer_mc.sun_moon_mc.y = Utils.map((currentDate.hours * 60) + currentDate.minutes,
															0,1440,0,Main.CONTAINER_HEIGHT);
		}
	}
}