﻿package 
{
	import flash.display.MovieClip;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import com.greensock.TweenLite;
	import com.greensock.easing.*;

	public class Player extends MovieClip 
	{
		public static const DOT_FREQUENCY : Number = 0.13;
		public static const STOMP_SPEED_FACTOR : Number = 6;
		
		public static const WALKING : String = "walking";
		public static const JUMPING : String = "jumping";
		public static const STOMPING : String = "stomping";
		public static const FALLING : String = "falling";
		
		public var animation_mc : MovieClip;
		public var splashes_mc : MovieClip;
		
		private var _title : String;
		private var _container : PlayerContainer;
		private var _movementMode : String;		
		private var _otherPlayer : Player;
		
		private var _dotTimer : Timer;
		
		private var _level : Level;
		
		public function Player() 
		{
			enterMovementMode(WALKING);
		}
		
		public function init(title : String, container : PlayerContainer, otherPlayer : Player, level : Level) : void
		{
			_title = title;
			_container = container;

			this.gotoAndStop(title);
			_container.background_layer_mc.init(this);
			
			_otherPlayer = otherPlayer;
			
			_level = level;
			
			_dotTimer = new Timer(Math.round(DOT_FREQUENCY * 1000), 0);
			_dotTimer.start();

			addEventListeners();
		}
		
		public function reset() : void
		{
			enterMovementMode(WALKING);
			_dotTimer.reset();
			_dotTimer.start();
			
			this.y = Main.CONTAINER_HEIGHT;
		}
		
		private function addEventListeners() : void
		{
			_dotTimer.addEventListener(TimerEvent.TIMER, handleTimer);
		}
		
		private function handleTimer (e : TimerEvent) : void
		{
			if (_movementMode == WALKING)
			{
				//addDot();
			}
			
		}
		
		public function addDot () : void
		{
			var dot : SpeedDot = new SpeedDot(this.x, this.y - 2, this);
			_container.dot_layer_mc.addObject(dot);
		}
		
		public function jump () : void
		{
			if (_movementMode == WALKING)
			{
				enterMovementMode(JUMPING);
				TweenLite.to(this, Main.JUMP_DURATION / 2, {y: this.y - Main.JUMP_HEIGHT, 
					ease:Sine.easeOut, onComplete:handleJumpUpFinished});
			}
		}
		
		private function handleJumpUpFinished () : void
		{
			if (movementMode == JUMPING)
			{
				TweenLite.to(this, Main.JUMP_DURATION / 2, {y: Main.CONTAINER_HEIGHT, 
					ease:Sine.easeIn, onComplete:handleJumpDownFinished});
			}
		}
		
		public function handleJumpDownFinished () : void
		{
			if (_movementMode != FALLING)
			{
				enterMovementMode(WALKING);
			}
		}
		
		public function stomp () : void
		{
			if (movementMode == JUMPING)
			{
				enterMovementMode(STOMPING);

				TweenLite.to(this, Main.JUMP_DURATION / 2 / STOMP_SPEED_FACTOR, {y: Main.CONTAINER_HEIGHT,  
					ease:Sine.easeOut, onComplete:handleStompFinished});
			}
		}
		
		public function handleStompFinished () : void
		{
			if (_otherPlayer.movementMode == WALKING)
			{
				_otherPlayer.moveUp();
				_level.shakeScreen(this);
			}
			
			if (_movementMode != FALLING)
			{
				enterMovementMode(WALKING);
			}
		}
		
		public function moveUp () : void
		{
			if (_movementMode == WALKING)
			{
				TweenLite.to(this, Main.MOVE_MAX_DURATION / 2, {y: Main.MOVE_MAX_HEIGHT, 
					ease:Sine.easeOut, onComplete:handleMoveUpFinished});
			}
		}
		
		public function fall () : void
		{
			enterMovementMode(FALLING);
			this.animation_mc.gotoAndStop("falling");
		}
		
		private function handleMoveUpFinished () : void
		{
			if (_movementMode != JUMPING && _movementMode != STOMPING)
			{
				TweenLite.to(this, Main.MOVE_MAX_DURATION / 2, {y: Main.CONTAINER_HEIGHT, 
					ease:Sine.easeIn, onComplete:handleMoveDownFinished});
			}
		}
		
		private function handleMoveDownFinished () : void
		{
			if (_movementMode != FALLING)
			{
				enterMovementMode(WALKING);
			}
		}
		
		private function enterMovementMode (m : String) : void
		{
			_movementMode = m;
			this.animation_mc.gotoAndStop(m);
			
			splashes_mc.visible = false;
			if (_movementMode == WALKING)
			{
				splashes_mc.visible = true;
			}
			/*else if (_movementMode == JUMPING)
			{
				
			}
			else if (_movementMode == STOMPING)
			{
				
			}*/
		}
		
		public function get title () : String
		{
			return _title;
		}
		
		public function get movementMode () : String
		{
			return _movementMode;
		}
	}
}